<?php
$post_format = get_post_format();
global $post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="top-info-detail post-layout">

        <?php if( $post_format == 'link' ) {
            $format = lindo_post_format_link_helper( get_the_content(), get_the_title() );
            $title = $format['title'];
            $link = lindo_get_link_attributes( $title );
            $thumb = lindo_post_thumbnail('', $link);
            echo trim($thumb);
        } else { ?>
            <div class="entry-thumb top-image <?php echo  (!has_post_thumbnail() ? 'no-thumb' : ''); ?>">
                <?php
                    $thumb = lindo_post_thumbnail();
                    echo trim($thumb);
                ?>
            </div>
        <?php } ?>
        
    </div>
    <div class="entry-content-detail">
        <div class="top-info">
           
            <div class="post-author">
                <a class="user" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="icon-user-avatar"></i><?php echo get_the_author(); ?>
                </a>
            </div>
            <?php lindo_post_categories($post); ?>
           
        </div>
         <!-- <?php if (get_the_title()) { ?>
            <h1 class="entry-title-detail">
                <?php the_title(); ?>
            </h1>
        <?php } ?> -->
        <div class="single-info info-bottom">
            <div class="entry-description">
                <?php
                    the_content();
                ?>
            </div><!-- /entry-content -->
            <?php
            wp_link_pages( array(
                'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'lindo' ) . '</span>',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
                'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'lindo' ) . ' </span>%',
                'separator'   => '',
            ) );
            ?>
            <?php  
                $posttags = get_the_tags();
            ?>
            <?php if( !empty($posttags) || lindo_get_config('show_blog_social_share', false) ){ ?>
                <div class="tag-social">
                    <?php lindo_post_tags(); ?>
                    <?php if( lindo_get_config('show_blog_social_share', false) ) {
                        get_template_part( 'template-parts/sharebox' );
                    } ?>
                </div>
            <?php } ?>
        </div>
    </div>
     <?php
        //Previous/next post navigation.
        lindo_post_nav();
    ?>
</article>