<?php 
    $thumbsize = !isset($thumbsize) ? lindo_get_config( 'blog_item_thumbsize', 'full' ) : $thumbsize;
    $thumb = lindo_display_post_thumb($thumbsize);
?>
<article <?php post_class('post post-layout post-grid-v2'); ?>>
   
    <?php if($thumb) {?>
        <div class="top-image image">
             <?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
                <span class="post-sticky"><?php echo esc_html__('Featured','lindo'); ?></span>
            <?php endif; ?>
            <?php
                $thumb = lindo_display_post_thumb($thumbsize);
                echo trim($thumb);
            ?>
          
            <div class="post-info">
                <div class="top-info">
                    <div class="post-author">
                        <a class="user" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="icon-user-avatar"></i><?php echo get_the_author(); ?>
                        </a>
                    </div>
                    <?php lindo_post_categories($post); ?>
                </div> 

                <?php if (get_the_title()) { ?>
                    <h4 class="entry-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h4>
                <?php } ?>
              
              <?php if (lindo_get_config('show_excerpt', false)) { ?>
                    <div class="description"><?php echo lindo_substring( get_the_excerpt(), 12, '...' ); ?></div>
                <?php } else{ ?>
                    <div class="description"><?php echo lindo_substring( get_the_content(), 12, '...' ); ?></div>
                <?php } ?>
                
               <div class="bottom-info flex">
                    <div class="ali-left clearfix">
                        <div class="post-date">
                            <a href="<?php the_permalink(); ?> " class="blog-time">
                                <i class="icon-calendar"></i><?php the_time( get_option('date_format', 'd M, Y') ); ?>
                            </a>
                        </div>
                    </div>
                    <div class="ali-right">
                        <?php if (lindo_get_config('show_readmore', false)) { ?>
                        <a class=" readmore" href="<?php the_permalink(); ?>">
                            <span><?php esc_html_e('Read More', 'lindo'); ?>
                        </span>
                        </a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        
        <?php }else{ ?>
         <div class="no-image">
             <?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
                <span class="post-sticky"><?php echo esc_html__('Featured','lindo'); ?></span>
            <?php endif; ?>
            <div class="post-info">
                 <div class="top-info">
                    <!-- <div class="post-date">
                        <a href="<?php the_permalink(); ?> " class="blog-time">
                            <i class="icon-calendar"></i><?php the_time( get_option('date_format', 'd M, Y') ); ?>
                        </a>
                    </div> -->
                    <div class="post-author">
                        <a class="user" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="icon-user-avatar"></i><?php echo get_the_author(); ?>
                        </a>
                    </div>
                    <?php lindo_post_categories($post); ?>
                </div>
                <?php if (get_the_title()) { ?>
                    <h4 class="entry-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h4>
                <?php } ?>
               
              <?php if (lindo_get_config('show_excerpt', false)) { ?>
                    <div class="description"><?php echo lindo_substring( get_the_excerpt(), 12, '...' ); ?></div>
                <?php } else{ ?>
                    <div class="description"><?php echo lindo_substring( get_the_content(), 12, '...' ); ?></div>
                <?php } ?>

                <div class="bottom-info flex">
                    <div class="ali-left clearfix">
                        <div class="post-date">
                            <a href="<?php the_permalink(); ?> " class="blog-time">
                                <i class="icon-calendar"></i><?php the_time( get_option('date_format', 'd M, Y') ); ?>
                            </a>
                        </div>
                    </div>
                    <div class="ali-right">
                        <?php if (lindo_get_config('show_readmore', false)) { ?>
                        <a class=" readmore" href="<?php the_permalink(); ?>">
                            <span><?php esc_html_e('Read More', 'lindo'); ?>
                        </span>
                        </a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>   
    <?php } ?>       
    
</article>