jQuery(document).ready(function($){
	"use strict";
	var lindo_upload;
	var lindo_selector;

	function lindo_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		lindo_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( lindo_upload ) {
			lindo_upload.open();
			return;
		} else {
			// Create the media frame.
			lindo_upload = wp.media.frames.lindo_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			lindo_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = lindo_upload.state().get('selection').first();

				lindo_upload.close();
				lindo_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					lindo_selector.find('.lindo_screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		lindo_upload.open();
	}

	function lindo_remove_file(selector) {
		selector.find('.lindo_screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').on('click', '.lindo_upload_image_action .remove-image', function(event) {
		lindo_remove_file( $(this).parent().parent() );
	});

	$('body').on('click', '.lindo_upload_image_action .add-image', function(event) {
		lindo_add_file(event, $(this).parent().parent());
	});

});