<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Lindo_Elementor_Special_Banner extends Widget_Base {

	public function get_name() {
        return 'lindo_element_special_banner';
    }

	public function get_title() {
        return esc_html__( 'Goal Special Banner', 'lindo' );
    }

	public function get_icon() {
        return 'eicon-image-box';
    }

	public function get_categories() {
        return [ 'lindo-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Special Banner', 'lindo' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'lindo' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
                'condition' => [
                    'image_icon' => 'image',
                ],
            ]
        );

        $repeater->add_control(
            'title_text',
            [
                'label' => esc_html__( 'Title', 'lindo' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your title', 'lindo' ),
            ]
        );

        $repeater->add_control(
            'products_count',
            [
                'label' => esc_html__( 'Number Count', 'lindo' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '10',
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link to', 'lindo' ),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'lindo' ),
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'banners',
            [
                'label' => esc_html__( 'Banners Item', 'lindo' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'animation',
            [
                'label' => esc_html__( 'Animation', 'lindo' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('None', 'lindo'),
                    'fade' => esc_html__('Fade', 'lindo'),
                    'fade-up' => esc_html__('Fade Up', 'lindo'),
                    'fade-down' => esc_html__('Fade Down', 'lindo'),
                    'fade-left' => esc_html__('Fade Left', 'lindo'),
                    'fade-right' => esc_html__('Fade Right', 'lindo'),
                    'fade-up-right' => esc_html__('Fade Up Right', 'lindo'),
                    'fade-up-left' => esc_html__('Fade Up Left', 'lindo'),
                    'fade-down-right' => esc_html__('Fade Down Right', 'lindo'),
                    'fade-down-left' => esc_html__('Fade Down Left', 'lindo'),
                    'flip-up' => esc_html__('Flip Up', 'lindo'),
                    'flip-down' => esc_html__('Flip Down', 'lindo'),
                    'flip-left' => esc_html__('Flip Left', 'lindo'),
                    'flip-right' => esc_html__('Flip Right', 'lindo'),
                    'slide-up' => esc_html__('Slide Up', 'lindo'),
                    'slide-down' => esc_html__('Slide Down', 'lindo'),
                    'slide-left' => esc_html__('Slide Left', 'lindo'),
                    'slide-right' => esc_html__('Slide Right', 'lindo'),
                    'zoom-in' => esc_html__('Zoom In', 'lindo'),
                    'zoom-in-up' => esc_html__('Zoom In Up', 'lindo'),
                    'zoom-in-down' => esc_html__('Zoom In Down', 'lindo'),
                    'zoom-in-left' => esc_html__('Zoom In Left', 'lindo'),
                    'zoom-in-right' => esc_html__('Zoom In Right', 'lindo'),
                    'zoom-out' => esc_html__('Zoom Out', 'lindo'),
                    'zoom-out-up' => esc_html__('Zoom Out Up', 'lindo'),
                    'zoom-out-down' => esc_html__('Zoom Out Down', 'lindo'),
                    'zoom-out-left' => esc_html__('Zoom Out Feft', 'lindo'),
                    'zoom-out-right' => esc_html__('Zoom Out Right', 'lindo')
                ),
                'default' => ''
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'lindo' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'lindo' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'lindo' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'lindo' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'lindo' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'lindo' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'lindo' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Style', 'lindo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'lindo' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .title a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Title Typography', 'lindo' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .title a, {{WRAPPER}} .title',
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($banners) ) {
            $rand_id = lindo_random_key();
            ?>
            <div class="widget-banners-box <?php echo esc_attr($el_class); ?>">
                <nav id="txtanimation-<?php echo esc_attr($rand_id); ?>" class="txtcollection text-<?php echo esc_attr($alignment); ?>" data-section-type="textanimation" data-section-id="<?php echo esc_attr($rand_id); ?>" data-animation="<?php echo esc_attr($animation); ?>">
                    <?php foreach ($banners as $item):
                        if ( ! empty( $item['link']['url'] ) ) {
                            echo '<a class="item__collection item_'.esc_attr($rand_id).'" href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>';
                        } else {
                            echo '<a class="item__collection item_'.esc_attr($rand_id).'" href="#">';
                        }
                    ?>
                            <?php echo wp_get_attachment_image($item['image']['id'], 'full', '', array( 'class' => 'img' )); ?>

                            <span class="h2 item__collection-name d-block"><?php echo esc_attr($item['title_text']); ?></span>
                            <?php if ( !empty($item['products_count']) ) { ?>
                                <span class="item__collection-sub font-family-2 text-uppercase d-block">
                                    <?php echo esc_attr($item['products_count']); ?> 
                                </span>
                            <?php } ?>
                           
                        </a>
                    <?php endforeach; ?>
                </nav>
            </div>
            <?php
        }
    }

}
if ( version_compare(ELEMENTOR_VERSION, '3.5.0', '<') ) {
    Plugin::instance()->widgets_manager->register_widget_type( new Lindo_Elementor_Special_Banner );
} else {
    Plugin::instance()->widgets_manager->register( new Lindo_Elementor_Special_Banner );
}