<?php

if ( !function_exists( 'lindo_product_metaboxes' ) ) {
	function lindo_product_metaboxes(array $metaboxes) {
		$prefix = 'goal_product_';
        $headers = array_merge( array('global' => esc_html__( 'Global Setting', 'lindo' )), lindo_get_header_layouts() );
	    $fields = array(
            array(
                'id' => $prefix.'header_type',
                'type' => 'select',
                'name' => esc_html__('Header Layout Type', 'lindo'),
                'options' => $headers
            ),
	    	array(
                'id' => $prefix.'layout_type',
                'type' => 'select',
                'name' => esc_html__('Layout Type', 'lindo'),
                'options' => array(
                    '' => esc_html__('Global Settings', 'lindo'),
                    'v1' => esc_html__('Layout 1', 'lindo'),
                    'v2' => esc_html__('Layout 2', 'lindo'),
                    'v3' => esc_html__('Layout 3', 'lindo'),
                    'v4' => esc_html__('Layout 4', 'lindo'),
                    'v5' => esc_html__('Layout 5', 'lindo'),
                    'v6' => esc_html__('Layout 6', 'lindo'),
                    'v7' => esc_html__('Layout 7', 'lindo'),
                )
            ),
            array(
                'id' => $prefix.'bg_color',
                'type' => 'colorpicker',
                'name' => esc_html__('Background Color', 'lindo'),
                'description' => esc_html__('For Layout 2 ', 'lindo'),
            ),
	    	array(
  				'name' => esc_html__( 'Review Video', 'lindo' ),
  				'id'   => $prefix.'review_video',
  				'type' => 'text',
  				'description' => esc_html__( 'You can enter a video youtube or vimeo', 'lindo' ),
  			),
        array(
          'name' => esc_html__( 'Features', 'lindo' ),
          'id'   => $prefix.'features',
          'type' => 'wysiwyg'
        ),
    	);
		
		// if ( lindo_is_sizeguides_activated() ) {
		// 	$fields[] = array(
  //               'id' => $prefix.'sizeguides_enable',
  //               'type' => 'select',
  //               'name' => esc_html__('Size Guides Enable', 'lindo'),
  //               'options' => array(
  //                   '' => esc_html__('Global Settings', 'lindo'),
  //                   'enable' => esc_html__('Enable', 'lindo'),
  //                   'disable' => esc_html__('Disable', 'lindo'),
  //               )
  //           );
		// }

	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'More Information', 'lindo' ),
			'object_types'              => array( 'product' ),
			'context'                   => 'normal',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'lindo_product_metaboxes' );
